(function ($) {
    'use strict';

    // Quality slider live display.
    $('#ace_webp_quality').on('input', function () {
        $('#ace-webp-quality-display').text(this.value);
    });

    // Bulk convert.
    var isConverting = false;
    var totalImages  = 0;
    var newlyConverted = 0;
    var offset       = 0;
    var batchSize    = 20;

    $('#ace-webp-bulk-convert').on('click', function () {
        if (isConverting) return;

        isConverting   = true;
        newlyConverted = 0;
        offset         = 0;

        $(this).prop('disabled', true).text('Converting\u2026');
        $('#ace-webp-progress-wrap').show();
        $('#ace-webp-progress-bar').css('width', '0%');
        $('#ace-webp-progress-text').text('Starting\u2026');

        processBatch();
    });

    function processBatch() {
        $.ajax({
            url:  aceWebp.ajaxUrl,
            type: 'POST',
            data: {
                action:     'ace_webp_bulk_convert',
                nonce:      aceWebp.nonce,
                offset:     offset,
                batch_size: batchSize
            },
            success: function (res) {
                if (!res.success) {
                    finish('Error: ' + (res.data || 'Unknown error'));
                    return;
                }

                totalImages    = res.data.total;
                newlyConverted += res.data.converted;
                offset         += batchSize;

                var processed = Math.min(offset, totalImages);
                var pct       = totalImages ? Math.round((processed / totalImages) * 100) : 100;

                $('#ace-webp-progress-bar').css('width', pct + '%');
                $('#ace-webp-progress-text').text(processed + ' / ' + totalImages + ' processed');

                if (offset < totalImages) {
                    processBatch();
                } else {
                    finish('Done! ' + newlyConverted + ' new images converted.');
                    refreshStats();
                }
            },
            error: function () {
                finish('A network error occurred. Please try again.');
            }
        });
    }

    function finish(msg) {
        isConverting = false;
        $('#ace-webp-bulk-convert').prop('disabled', false).text('Start Bulk Conversion');
        $('#ace-webp-progress-text').text(msg);
    }

    function refreshStats() {
        $.post(aceWebp.ajaxUrl, {
            action: 'ace_webp_get_stats',
            nonce:  aceWebp.nonce
        }, function (res) {
            if (!res.success) return;
            $('#ace-webp-stat-total').text(res.data.total);
            $('#ace-webp-stat-converted').text(res.data.converted);
            $('#ace-webp-stat-saved').text(res.data.saved);
        });
    }

})(jQuery);
